# Script for calculation of domain coordination

library(dplyr)
library(readr)


# Load pixel value from binarized images for measurements (binarized or non-binarized):
sample_a <- read_csv("Coord_mem1.csv")
sample_b <- read_csv("Coord_mem2.csv")

#sample_a <- read_csv("Coord_mem1_bin.csv")
#sample_b <- read_csv("Coord_mem2_bin.csv")


colnames(sample_a) <- c("distance","value") # rename columns
sample_a$membrane <- c("mem1")           # attach membrane ID value

colnames(sample_b) <- c("distance","value") # rename columns
sample_b$membrane <- c("mem2")           # attach membrane ID value

mysample <- sample_a[,1:2]    # binding samples into single data frame:
mysample$mem2 <- sample_b$value

colnames(mysample) <- c("distance","mem1", "mem2")

# Calculating intensity difference between membranes
mysample <- mysample %>%
  mutate(diff = sqrt((mem1-mem2)^2))      # sqrt of diff^2 yields only positive differences

# ******************************************************************************************************************
# Statistics

cor.test(sample_a$value, sample_b$value, method = "pearson")
cor.test(sample_a$value, sample_b$value, method = "spearman")
cor.test(sample_a$value, sample_b$value, method = "kendall")


adj.sample_a <- sample_a %>%
  mutate(ratio = value/max(value)) %>%      # relative intensity to max
  mutate(adj.ratio = ratio/mean(ratio))     # adjust ratio to mean intensity ratio to adjust for weaker membranes -> highlights coordination

adj.sample_b <- sample_b %>%
  mutate(ratio = value/max(value)) %>%      # relative intensity to max
  mutate(adj.ratio = ratio/mean(ratio))     # adjust ratio to mean intensity ratio to adjust for weaker membranes -> highlights coordination


mynewsample <- rbind(adj.sample_a, adj.sample_b)


pdf("GFP intensity coordination.pdf", useDingbats = F, width = 5, height = 5)

plot(adj.ratio ~ distance, adj.sample_a, type = "l", lwd = 2, #lty = 2,
     xlab = c("Distance [um]"),
     ylab = c("Relative GFP intensity to the mean")
     )
lines(adj.ratio ~ distance, adj.sample_b, type = "l", lwd = 2, col = c("black"), lty = 2)
legend(3,2.75, legend=c("Membrane 1", "Membrane 2"),
       col=c("black", "black"), lty=1:2, cex=1, box.lty=0)


model <- lm(sample_a$value~sample_b$value)
summary(model)

rsq <- round(summary(model)$adj.r.squared, digits = 3)
pvalue <- wilcox.test(sample_a$value, sample_b$value)

text(4.38, 2.25, bquote(R^2 == .(rsq)))
text(4.5, 2, bquote(p == .(pvalue$p.value)))

dev.off()